//Original Version with Timers

#include <iostream>			//for cin >> and cout <<
#include <fstream>			//for output file
#include <conio.h>			//for _kbhit
#include <windows.h>
#include "stdio.h"

using namespace std;

// *** declare constants and variables used for timing ********************************
#define million 1.0E6		// to get times in micro seconds
int iterations = 1000;		// execute the main drawing loop this number of times
float frequency;			// timing clock frequency
float elapsed_time;			// time for 1 iteration
float accumulated_elapsed_time;

int tree_sizes[] = {4,5,6,8,10,15,20,25,30,40};
const char XT_times[] = "Timing.txt";  // filename for the timing data output file

// ************************************************************************************

//declare variables
int height;					//height of the tree
int maxBranchLine;			//loop counter variable
char buffer[2500];				//store a whole tree to print

void main(void) 				//draw Xmas tree
{
	LARGE_INTEGER start, end, runtimestart, runtimeend, freq;

	// ************** Set up timer ***************************************************
	QueryPerformanceFrequency(&freq);
	QueryPerformanceCounter(&runtimestart);

	frequency = (float)freq.LowPart;
	ofstream tree_times;
	tree_times.open (XT_times, ios::out);
	tree_times << "Height\t\tTotal\t\tAverage (all micro seconds) for "<< iterations << " iterations. Frequency= "<< frequency <<"\n";
//sizeof(tree_sizes)
	for (int tree = 0; tree < 10; tree++)
	{ //***
		height = tree_sizes[tree];
		maxBranchLine = (height - 2);
		accumulated_elapsed_time = 0.0;
		for (int i = 0; i <iterations; i++)
		{ //*****
		// ************** Set up timer ***************************************************
			QueryPerformanceCounter(&start);
		// ************** code to be timed ***********************************************

		//drawBranches ecx = branchLine ebx = maxBranchLine
			__asm {
				mov		ecx, 1					; set branchLine to 1
				mov		eax, ecx				; eax used for compare
				mov		ebx, [maxBranchLine]	; move maxBranchLine into a register
				mov		edi, 0					; use edx to access char buffer
DrawABranch:	mov		edx, ebx				; move maxBranchLine into counter
				sub		edx, ecx				; sub branchLine from the counter
c1:				
				cmp		edx, eax				; If counter < 1
				jl		c2						; jump out of loop to c2
				dec		edx						; else, decrement counter
				mov		byte ptr buffer [edi],20h	; print a space
				inc		edi						; increment buffer counter
				jmp		c1						; jump to beginning of loop
c2:				
				mov		edx, ecx				; set counter to current branchLine
				add		edx, edx				; multiply the counter by 2
				sub		edx, eax				; sub 1 from the counter
c3:				
				mov		byte ptr buffer [edi],23h	; print a leaf
				inc		edi						; increment buffer counter
				dec		edx						; decrement the counter
				cmp		edx, eax				; if (counter >= 1)
				jge		c3						; jump to c3
				mov byte ptr buffer [edi],0Ah	; else, print a new line
				inc edi							; increment buffer counter
				inc		ecx						; increase branchLine
				cmp		ecx, ebx				; if (branchLine <= to maxBranchLine)
				__emit 0x3E						;  statically predict a branch as taken 
				jle		DrawABranch				; jump to drawABranch
		//end of drawBranches
		//draw a trunk		
				mov		edx, eax				; else, set counter to 1
trunk1:			
				mov		byte ptr buffer [edi],20h	; print a space
				inc		edi						; increment buffer counter
				inc		edx						; increment the counter
				cmp		edx, ebx				; if (counter < maxBranchLine)
				jl		trunk1					; print a space
				mov byte ptr buffer [edi],7Ch	; else, print a trunk symbol
				inc edi							; increment buffer counter
				mov byte ptr buffer [edi],0Ah	; print a new line
				inc edi							; increment buffer counter
				mov		edx, eax				; set counter to 1
trunk2:
				mov		byte ptr buffer [edi],20h	; print a space
				inc		edi						; increment buffer counter
				inc		edx						; increment the counter
				cmp		edx, ebx				; if (counter < maxBranchLine)
				jl		trunk2					; draw a space
				mov byte ptr buffer [edi],7Ch	; else, print a trunk symbol
				inc edi							; increment buffer counter
				mov byte ptr buffer [edi],0Ah	; print a new line
			}
	//end of drawTrunk	

			printf(buffer);
			
		// ************** End of timed code **********************************************
		
		QueryPerformanceCounter(&end);

		memset(buffer, 0, strlen(buffer));

		long counts = (end.LowPart - start.LowPart);
		elapsed_time = (float)counts/frequency;

		accumulated_elapsed_time += elapsed_time;
		} //*****

	float average_elapsed_time = accumulated_elapsed_time/(float) iterations;
	tree_times << height << "\t\t"<< accumulated_elapsed_time * million << "\t\t" << average_elapsed_time * million <<"\n";
	} //***

	QueryPerformanceCounter(&runtimeend);
    long runtime = (runtimeend.LowPart - runtimestart.LowPart);
	elapsed_time = (float)runtime/frequency;
	tree_times << "\nOverall run time = " << elapsed_time << " seconds\n";
	tree_times.close();


	// *******************************************************************************

}

